<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Operation extends Model 
{

    protected $table = 'operations';
    public $timestamps = true;
    protected $fillable = array('type', 'report', 'date', 'pationt_id', 'blood_bags_num', 'price', 'room_id');

    public function pationt()
    {
        return $this->belongsTo('App\Models\Pationt');
    }

    public function room()
    {
        return $this->belongsTo('App\Models\Room');
    }

    public function tools()
    {
        return $this->hasMany('App\Models\OperationTool');
    }

    public function reports()
    {
        return $this->morphMany('App\Models\Report');
    }

    public function medicine_quantities()
    {
        return $this->morphMany('App\Models\MedicineQuantity');
    }

}